/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#include "stdafx.h"

#include "Helper.h"

#define PKCS_UNKNOWN_INFO   PKCS_SPL_END_LIST

/* PKCS return code */
PKCS_SPL_TS_TextCode PKCS_return_code[] =
{
	{ CKR_CANCEL                            ,_CK("CKR_CANCEL")},
	{ CKR_HOST_MEMORY                       ,_CK("CKR_HOST_MEMORY")},
	{ CKR_SLOT_ID_INVALID                   ,_CK("CKR_SLOT_ID_INVALID")},
	{ CKR_ARGUMENTS_BAD                     ,_CK("CKR_ARGUMENTS_BAD")},
	{ CKR_ATTRIBUTE_READ_ONLY               ,_CK("CKR_ATTRIBUTE_READ_ONLY")},
	{ CKR_ATTRIBUTE_SENSITIVE               ,_CK("CKR_ATTRIBUTE_SENSITIVE")},
	{ CKR_ATTRIBUTE_TYPE_INVALID            ,_CK("CKR_ATTRIBUTE_TYPE_INVALID")},
	{ CKR_ATTRIBUTE_VALUE_INVALID           ,_CK("CKR_ATTRIBUTE_VALUE_INVALID")},
	{ CKR_DATA_INVALID                      ,_CK("CKR_DATA_INVALID")},
	{ CKR_DATA_LEN_RANGE                    ,_CK("CKR_DATA_LEN_RANGE")},
	{ CKR_DEVICE_ERROR                      ,_CK("CKR_DEVICE_ERROR")},
	{ CKR_DEVICE_MEMORY                     ,_CK("CKR_DEVICE_MEMORY")},
	{ CKR_DEVICE_REMOVED                    ,_CK("CKR_DEVICE_REMOVED")},
	{ CKR_ENCRYPTED_DATA_INVALID            ,_CK("CKR_ENCRYPTED_DATA_INVALID")},
	{ CKR_ENCRYPTED_DATA_LEN_RANGE          ,_CK("CKR_ENCRYPTED_DATA_LEN_RANGE")},
	{ CKR_FUNCTION_CANCELED                 ,_CK("CKR_FUNCTION_CANCELED")},
	{ CKR_FUNCTION_NOT_PARALLEL             ,_CK("CKR_FUNCTION_NOT_PARALLEL")},
	{ CKR_FUNCTION_NOT_SUPPORTED            ,_CK("CKR_FUNCTION_NOT_SUPPORTED")},
	{ CKR_KEY_HANDLE_INVALID                ,_CK("CKR_KEY_HANDLE_INVALID")},
	{ CKR_KEY_SIZE_RANGE                    ,_CK("CKR_KEY_SIZE_RANGE")},
	{ CKR_KEY_TYPE_INCONSISTENT             ,_CK("CKR_KEY_TYPE_INCONSISTENT")},
	{ CKR_MECHANISM_INVALID                 ,_CK("CKR_MECHANISM_INVALID")},
	{ CKR_MECHANISM_PARAM_INVALID           ,_CK("CKR_MECHANISM_PARAM_INVALID")},
	{ CKR_OBJECT_HANDLE_INVALID             ,_CK("CKR_OBJECT_HANDLE_INVALID")},
	{ CKR_OPERATION_ACTIVE                  ,_CK("CKR_OPERATION_ACTIVE")},
	{ CKR_OPERATION_NOT_INITIALIZED         ,_CK("CKR_OPERATION_NOT_INITIALIZED")},
	{ CKR_PIN_INCORRECT                     ,_CK("CKR_PIN_INCORRECT")},
	{ CKR_PIN_INVALID                       ,_CK("CKR_PIN_INVALID")},
	{ CKR_PIN_LEN_RANGE                     ,_CK("CKR_PIN_LEN_RANGE")},
	{ CKR_SESSION_CLOSED                    ,_CK("CKR_SESSION_CLOSED")},
	{ CKR_SESSION_COUNT                     ,_CK("CKR_SESSION_COUNT")},
	{ CKR_SESSION_HANDLE_INVALID            ,_CK("CKR_SESSION_HANDLE_INVALID")},
	{ CKR_SESSION_PARALLEL_NOT_SUPPORTED    ,_CK("CKR_SESSION_PARALLEL_NOT_SUPPORTED")},
	{ CKR_SESSION_READ_ONLY                 ,_CK("CKR_SESSION_READ_ONLY")},
	{ CKR_SIGNATURE_INVALID                 ,_CK("CKR_SIGNATURE_INVALID")},
	{ CKR_SIGNATURE_LEN_RANGE               ,_CK("CKR_SIGNATURE_LEN_RANGE")},
	{ CKR_TEMPLATE_INCOMPLETE               ,_CK("CKR_TEMPLATE_INCOMPLETE")},
	{ CKR_TEMPLATE_INCONSISTENT             ,_CK("CKR_TEMPLATE_INCONSISTENT")},
	{ CKR_TOKEN_NOT_PRESENT                 ,_CK("CKR_TOKEN_NOT_PRESENT")},
	{ CKR_TOKEN_NOT_RECOGNIZED              ,_CK("CKR_TOKEN_NOT_RECOGNIZED")},
	{ CKR_TOKEN_WRITE_PROTECTED             ,_CK("CKR_TOKEN_WRITE_PROTECTED")},
	{ CKR_UNWRAPPING_KEY_HANDLE_INVALID     ,_CK("CKR_UNWRAPPING_KEY_HANDLE_INVALID")},
	{ CKR_UNWRAPPING_KEY_SIZE_RANGE         ,_CK("CKR_UNWRAPPING_KEY_SIZE_RANGE")},
	{ CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT  ,_CK("CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT")},
	{ CKR_USER_ALREADY_LOGGED_IN            ,_CK("CKR_USER_ALREADY_LOGGED_IN")},
	{ CKR_USER_NOT_LOGGED_IN                ,_CK("CKR_USER_NOT_LOGGED_IN")},
	{ CKR_USER_PIN_NOT_INITIALIZED          ,_CK("CKR_USER_PIN_NOT_INITIALIZED")},
	{ CKR_USER_TYPE_INVALID                 ,_CK("CKR_USER_TYPE_INVALID")},
	{ CKR_WRAPPED_KEY_INVALID               ,_CK("CKR_WRAPPED_KEY_INVALID")},
	{ CKR_WRAPPED_KEY_LEN_RANGE             ,_CK("CKR_WRAPPED_KEY_LEN_RANGE")},
	{ CKR_WRAPPING_KEY_HANDLE_INVALID       ,_CK("CKR_WRAPPING_KEY_HANDLE_INVALID")},
	{ CKR_WRAPPING_KEY_SIZE_RANGE           ,_CK("CKR_WRAPPING_KEY_SIZE_RANGE")},
	{ CKR_WRAPPING_KEY_TYPE_INCONSISTENT    ,_CK("CKR_WRAPPING_KEY_TYPE_INCONSISTENT")},
	{ CKR_VENDOR_DEFINED                    ,_CK("CKR_VENDOR_DEFINED")},
    { CKR_GENERAL_ERROR                     ,_CK("CKR_GENERAL_ERROR")},
	{ CKR_OK                                ,_CK("CKR_OK")}
};

/* PKCS attributes */
PKCS_SPL_TS_TextCode PKCS_attribute[] =
{
	{CKA_TOKEN,           _CK("CKA_TOKEN            ")},
	{CKA_PRIVATE,         _CK("CKA_PRIVATE          ")},
	{CKA_LABEL,           _CK("CKA_LABEL            ")},
	{CKA_APPLICATION,     _CK("CKA_APPLICATION      ")},
	{CKA_VALUE,           _CK("CKA_VALUE            ")},
	{CKA_CERTIFICATE_TYPE,_CK("CKA_CERTIFICATE_TYPE ")},
	{CKA_ISSUER,          _CK("CKA_ISSUER           ")},
	{CKA_SERIAL_NUMBER,   _CK("CKA_SERIAL_NUMBER    ")},
	{CKA_KEY_TYPE,        _CK("CKA_KEY_TYPE         ")},
	{CKA_SUBJECT,         _CK("CKA_SUBJECT          ")},
	{CKA_ID,              _CK("CKA_ID               ")},
	{CKA_SENSITIVE,       _CK("CKA_SENSITIVE        ")},
	{CKA_ENCRYPT,         _CK("CKA_ENCRYPT          ")},
	{CKA_DECRYPT,         _CK("CKA_DECRYPT          ")},
	{CKA_WRAP,            _CK("CKA_WRAP             ")},
	{CKA_UNWRAP,          _CK("CKA_UNWRAP           ")},
	{CKA_SIGN,            _CK("CKA_SIGN             ")},
	{CKA_SIGN_RECOVER,    _CK("CKA_SIGN_RECOVER     ")},
	{CKA_VERIFY,          _CK("CKA_VERIFY           ")},
	{CKA_VERIFY_RECOVER,  _CK("CKA_VERIFY_RECOVER   ")},
	{CKA_DERIVE,          _CK("CKA_DERIVE           ")},
	{CKA_START_DATE,      _CK("CKA_START_DATE       ")},
	{CKA_END_DATE,        _CK("CKA_END_DATE         ")},
	{CKA_MODULUS,         _CK("CKA_MODULUS          ")},
	{CKA_MODULUS_BITS,    _CK("CKA_MODULUS_BITS     ")},
	{CKA_PUBLIC_EXPONENT, _CK("CKA_PUBLIC_EXPONENT  ")},
	{CKA_PRIVATE_EXPONENT,_CK("CKA_PRIVATE_EXPONENT ")},
	{CKA_PRIME_1,         _CK("CKA_PRIME_1          ")},
	{CKA_PRIME_2,         _CK("CKA_PRIME_2          ")},
	{CKA_EXPONENT_1,      _CK("CKA_EXPONENT_1       ")},
	{CKA_EXPONENT_2,      _CK("CKA_EXPONENT_2       ")},
	{CKA_COEFFICIENT,     _CK("CKA_COEFFICIENT      ")},
	{CKA_PRIME,           _CK("CKA_PRIME            ")},
	{CKA_SUBPRIME,        _CK("CKA_SUBPRIME         ")},
	{CKA_BASE,            _CK("CKA_BASE             ")},
	{CKA_VALUE_BITS,      _CK("CKA_VALUE_BITS       ")},
	{CKA_VALUE_LEN,       _CK("CKA_VALUE_LEN        ")},
	{CKA_VENDOR_DEFINED,  _CK("CKA_VENDOR_DEFINED   ")},
	{CKA_CLASS,           _CK("CKA_CLASS            ")}
};

/* PKCS sessions*/
PKCS_SPL_TS_TextCode PKCS_session_state[] =
{
	{ CKS_RO_USER_FUNCTIONS, _CK("CKS_RO_USER_FUNCTIONS")},
	{ CKS_RW_PUBLIC_SESSION, _CK("CKS_RW_PUBLIC_SESSION")},
	{ CKS_RW_USER_FUNCTIONS, _CK("CKS_RW_USER_FUNCTIONS")},
	{ CKS_RW_SO_FUNCTIONS,   _CK("CKS_RW_SO_FUNCTIONS")},
	{ CKS_RO_PUBLIC_SESSION, _CK("CKS_RO_PUBLIC_SESSION")},
};

PKCS_SPL_TS_TextCode PKCS_session_flag[] = 
{
	{ CKF_RW_SESSION,                                          _CK("CKF_RW_SESSION")},
	{ CKF_SERIAL_SESSION,                                      _CK("CKF_SERIAL_SESSION")},
	{ CKF_RW_SESSION+CKF_SERIAL_SESSION,                       _CK("RW + SERIAL SESSION")},
	{ PKCS_UNKNOWN_INFO,                                       _CK("Undefine value")},
};

/* PKCS mechanisms */
PKCS_SPL_TS_TextCode PKCS_mechanism[] =
{
    { CKM_RSA_PKCS                   ,_CK("CKM_RSA_PKCS")},
    { CKM_RSA_9796                   ,_CK("CKM_RSA_9796")},
    { CKM_RSA_X_509                  ,_CK("CKM_RSA_X_509")},
    { CKM_DSA_KEY_PAIR_GEN           ,_CK("CKM_DSA_KEY_PAIR_GEN")},
    { CKM_DSA                        ,_CK("CKM_DSA")},
    { CKM_DH_PKCS_KEY_PAIR_GEN       ,_CK("CKM_DH_PKCS_KEY_PAIR_GEN")},
    { CKM_DH_PKCS_DERIVE             ,_CK("CKM_DH_PKCS_DERIVE")},
    { CKM_RC2_KEY_GEN                ,_CK("CKM_RC2_KEY_GEN")},
    { CKM_RC2_ECB                    ,_CK("CKM_RC2_ECB")},
    { CKM_RC2_CBC                    ,_CK("CKM_RC2_CBC")},
    { CKM_RC2_MAC                    ,_CK("CKM_RC2_MAC")},
    { CKM_RC4_KEY_GEN                ,_CK("CKM_RC4_KEY_GEN")},
    { CKM_RC4                        ,_CK("CKM_RC4")},
    { CKM_DES_KEY_GEN                ,_CK("CKM_DES_KEY_GEN")},
    { CKM_DES_ECB                    ,_CK("CKM_DES_ECB")},
    { CKM_DES_CBC                    ,_CK("CKM_DES_CBC")},
    { CKM_DES_MAC                    ,_CK("CKM_DES_MAC")},
    { CKM_DES2_KEY_GEN               ,_CK("CKM_DES2_KEY_GEN")},
    { CKM_DES3_KEY_GEN               ,_CK("CKM_DES3_KEY_GEN")},
    { CKM_DES3_ECB                   ,_CK("CKM_DES3_ECB")},
    { CKM_DES3_CBC                   ,_CK("CKM_DES3_CBC")},
    { CKM_DES3_MAC                   ,_CK("CKM_DES3_MAC")},
    { CKM_MD2                        ,_CK("CKM_MD2")},
    { CKM_MD5                        ,_CK("CKM_MD5")},
    { CKM_SHA_1                      ,_CK("CKM_SHA_1")},
    { CKM_VENDOR_DEFINED             ,_CK("CKM_VENDOR_DEFINED")},
    { CKM_SHA1_RSA_PKCS              ,_CK("CKM_SHA1_RSA_PKCS")},
    { CKM_DSA_SHA1                   ,_CK("CKM_DSA_SHA1")},
    { CKM_MD2_RSA_PKCS               ,_CK("CKM_MD2_RSA_PKCS")},
    { CKM_MD5_RSA_PKCS               ,_CK("CKM_MD5_RSA_PKCS")},
    { CKM_RC2_MAC_GENERAL            ,_CK("CKM_RC2_MAC_GENERAL")},
    { CKM_RC2_CBC_PAD                ,_CK("CKM_RC2_CBC_PAD")},
    { CKM_DES_MAC_GENERAL            ,_CK("CKM_DES_MAC_GENERAL")},
    { CKM_DES_CBC_PAD                ,_CK("CKM_DES_CBC_PAD")},
    { CKM_DES3_MAC_GENERAL           ,_CK("CKM_DES3_MAC_GENERAL")},
    { CKM_DES3_CBC_PAD               ,_CK("CKM_DES3_CBC_PAD")},
    { CKM_CDMF_KEY_GEN               ,_CK("CKM_CDMF_KEY_GEN")},
    { CKM_CDMF_ECB                   ,_CK("CKM_CDMF_ECB")},
    { CKM_CDMF_CBC                   ,_CK("CKM_CDMF_CBC")},
    { CKM_CDMF_MAC                   ,_CK("CKM_CDMF_MAC")},
    { CKM_CDMF_MAC_GENERAL           ,_CK("CKM_CDMF_MAC_GENERAL")},
    { CKM_CDMF_CBC_PAD               ,_CK("CKM_CDMF_CBC_PAD")},
    { CKM_MD2_HMAC                   ,_CK("CKM_MD2_HMAC")},
    { CKM_MD2_HMAC_GENERAL           ,_CK("CKM_MD2_HMAC_GENERAL")},
    { CKM_MD5                        ,_CK("CKM_MD5")},
    { CKM_MD5_HMAC                   ,_CK("CKM_MD5_HMAC")},
    { CKM_MD5_HMAC_GENERAL           ,_CK("CKM_MD5_HMAC_GENERAL")},
    { CKM_SHA_1                      ,_CK("CKM_SHA_1")},
    { CKM_SHA_1_HMAC                 ,_CK("CKM_SHA_1_HMAC")},
    { CKM_SHA_1_HMAC_GENERAL         ,_CK("CKM_SHA_1_HMAC_GENERAL")},
    { CKM_CAST_KEY_GEN               ,_CK("CKM_CAST_KEY_GEN")},
    { CKM_CAST_ECB                   ,_CK("CKM_CAST_ECB")},
    { CKM_CAST_CBC                   ,_CK("CKM_CAST_CBC")},
    { CKM_CAST_MAC                   ,_CK("CKM_CAST_MAC")},
    { CKM_CAST_MAC_GENERAL           ,_CK("CKM_CAST_MAC_GENERAL")},
    { CKM_CAST_CBC_PAD               ,_CK("CKM_CAST_CBC_PAD")},
    { CKM_CAST3_KEY_GEN              ,_CK("CKM_CAST3_KEY_GEN")},
    { CKM_CAST3_ECB                  ,_CK("CKM_CAST3_ECB")},
    { CKM_CAST3_CBC                  ,_CK("CKM_CAST3_CBC")},
    { CKM_CAST3_MAC                  ,_CK("CKM_CAST3_MAC")},
    { CKM_CAST3_MAC_GENERAL          ,_CK("CKM_CAST3_MAC_GENERAL")},
    { CKM_CAST3_CBC_PAD              ,_CK("CKM_CAST3_CBC_PAD")},
    { CKM_CAST5_KEY_GEN              ,_CK("CKM_CAST5_KEY_GEN")},
    { CKM_CAST5_ECB                  ,_CK("CKM_CAST5_ECB")},
    { CKM_CAST5_CBC                  ,_CK("CKM_CAST5_CBC")},
    { CKM_CAST5_MAC                  ,_CK("CKM_CAST5_MAC")},
    { CKM_CAST5_MAC_GENERAL          ,_CK("CKM_CAST5_MAC_GENERAL")},
    { CKM_CAST5_CBC_PAD              ,_CK("CKM_CAST5_CBC_PAD")},
    { CKM_RC5_KEY_GEN                ,_CK("CKM_RC5_KEY_GEN")},
    { CKM_RC5_ECB                    ,_CK("CKM_RC5_ECB")},
    { CKM_RC5_CBC                    ,_CK("CKM_RC5_CBC")},
    { CKM_RC5_MAC                    ,_CK("CKM_RC5_MAC")},
    { CKM_RC5_MAC_GENERAL            ,_CK("CKM_RC5_MAC_GENERAL")},
    { CKM_RC5_CBC_PAD                ,_CK("CKM_RC5_CBC_PAD")},
    { CKM_IDEA_KEY_GEN               ,_CK("CKM_IDEA_KEY_GEN")},
    { CKM_IDEA_ECB                   ,_CK("CKM_IDEA_ECB")},
    { CKM_IDEA_CBC                   ,_CK("CKM_IDEA_CBC")},
    { CKM_IDEA_MAC                   ,_CK("CKM_IDEA_MAC")},
    { CKM_IDEA_MAC_GENERAL           ,_CK("CKM_IDEA_MAC_GENERAL")},
    { CKM_IDEA_CBC_PAD               ,_CK("CKM_IDEA_CBC_PAD")},
    { CKM_GENERIC_SECRET_KEY_GEN     ,_CK("CKM_GENERIC_SECRET_KEY_GEN")},
    { CKM_CONCATENATE_BASE_AND_KEY   ,_CK("CKM_CONCATENATE_BASE_AND_KEY")},
    { CKM_CONCATENATE_BASE_AND_DATA  ,_CK("CKM_CONCATENATE_BASE_AND_DATA")},
    { CKM_CONCATENATE_DATA_AND_BASE  ,_CK("CKM_CONCATENATE_DATA_AND_BASE")},
    { CKM_XOR_BASE_AND_DATA          ,_CK("CKM_XOR_BASE_AND_DATA")},
    { CKM_EXTRACT_KEY_FROM_KEY       ,_CK("CKM_EXTRACT_KEY_FROM_KEY")},
    { CKM_SSL3_PRE_MASTER_KEY_GEN    ,_CK("CKM_SSL3_PRE_MASTER_KEY_GEN")},
    { CKM_SSL3_MASTER_KEY_DERIVE     ,_CK("CKM_SSL3_MASTER_KEY_DERIVE")},
    { CKM_SSL3_KEY_AND_MAC_DERIVE    ,_CK("CKM_SSL3_KEY_AND_MAC_DERIVE")},
    { CKM_SSL3_MD5_MAC               ,_CK("CKM_SSL3_MD5_MAC")},
    { CKM_SSL3_SHA1_MAC              ,_CK("CKM_SSL3_SHA1_MAC")},
    { CKM_MD5_KEY_DERIVATION         ,_CK("CKM_MD5_KEY_DERIVATION")},
    { CKM_MD2_KEY_DERIVATION         ,_CK("CKM_MD2_KEY_DERIVATION")},
    { CKM_SHA1_KEY_DERIVATION        ,_CK("CKM_SHA1_KEY_DERIVATION")},
    { CKM_PBE_MD2_DES_CBC            ,_CK("CKM_PBE_MD2_DES_CBC")},
    { CKM_PBE_MD5_DES_CBC            ,_CK("CKM_PBE_MD5_DES_CBC")},
    { CKM_PBE_MD5_CAST_CBC           ,_CK("CKM_PBE_MD5_CAST_CBC")},
    { CKM_PBE_MD5_CAST3_CBC          ,_CK("CKM_PBE_MD5_CAST3_CBC")},
    { CKM_PBE_MD5_CAST5_CBC          ,_CK("CKM_PBE_MD5_CAST5_CBC")},
    { CKM_PBE_SHA1_CAST5_CBC         ,_CK("CKM_PBE_SHA1_CAST5_CBC")},
    { CKM_KEY_WRAP_LYNKS             ,_CK("CKM_KEY_WRAP_LYNKS")},
    { CKM_KEY_WRAP_SET_OAEP          ,_CK("CKM_KEY_WRAP_SET_OAEP")},
    { CKM_SKIPJACK_KEY_GEN           ,_CK("CKM_SKIPJACK_KEY_GEN")},
    { CKM_SKIPJACK_ECB64             ,_CK("CKM_SKIPJACK_ECB64")},
    { CKM_SKIPJACK_CBC64             ,_CK("CKM_SKIPJACK_CBC64")},
    { CKM_SKIPJACK_OFB64             ,_CK("CKM_SKIPJACK_OFB64")},
    { CKM_SKIPJACK_CFB64             ,_CK("CKM_SKIPJACK_CFB64")},
    { CKM_SKIPJACK_CFB32             ,_CK("CKM_SKIPJACK_CFB32")},
    { CKM_SKIPJACK_CFB16             ,_CK("CKM_SKIPJACK_CFB16")},
    { CKM_SKIPJACK_CFB8              ,_CK("CKM_SKIPJACK_CFB8")},
    { CKM_SKIPJACK_WRAP              ,_CK("CKM_SKIPJACK_WRAP")},
    { CKM_SKIPJACK_PRIVATE_WRAP      ,_CK("CKM_SKIPJACK_PRIVATE_WRAP")},
    { CKM_SKIPJACK_RELAYX            ,_CK("CKM_SKIPJACK_RELAYX")},
    { CKM_KEA_KEY_PAIR_GEN           ,_CK("CKM_KEA_KEY_PAIR_GEN")},
    { CKM_KEA_KEY_DERIVE             ,_CK("CKM_KEA_KEY_DERIVE")},
    { CKM_FORTEZZA_TIMESTAMP         ,_CK("CKM_FORTEZZA_TIMESTAMP")},
    { CKM_BATON_KEY_GEN              ,_CK("CKM_BATON_KEY_GEN")},
    { CKM_BATON_ECB128               ,_CK("CKM_BATON_ECB128")},
    { CKM_BATON_ECB96                ,_CK("CKM_BATON_ECB96")},
    { CKM_BATON_CBC128               ,_CK("CKM_BATON_CBC128")},
    { CKM_BATON_COUNTER              ,_CK("CKM_BATON_COUNTER")},
    { CKM_BATON_SHUFFLE              ,_CK("CKM_BATON_SHUFFLE")},
    { CKM_BATON_WRAP                 ,_CK("CKM_BATON_WRAP")},
    { CKM_ECDSA_KEY_PAIR_GEN         ,_CK("CKM_ECDSA_KEY_PAIR_GEN")},
    { CKM_ECDSA                      ,_CK("CKM_ECDSA")},
    { CKM_ECDSA_SHA1                 ,_CK("CKM_ECDSA_SHA1")},
    { CKM_JUNIPER_KEY_GEN            ,_CK("CKM_JUNIPER_KEY_GEN")},
    { CKM_JUNIPER_ECB128             ,_CK("CKM_JUNIPER_ECB128")},
    { CKM_JUNIPER_CBC128             ,_CK("CKM_JUNIPER_CBC128")},
    { CKM_JUNIPER_COUNTER            ,_CK("CKM_JUNIPER_COUNTER")},
    { CKM_JUNIPER_SHUFFLE            ,_CK("CKM_JUNIPER_SHUFFLE")},
    { CKM_JUNIPER_WRAP               ,_CK("CKM_JUNIPER_WRAP")},
    { CKM_FASTHASH                   ,_CK("CKM_FASTHASH")},
    { CKM_RSA_PKCS_KEY_PAIR_GEN      ,_CK("CKM_RSA_PKCS_KEY_PAIR_GEN")}
};

/* PKCS key types */
PKCS_SPL_TS_TextCode PKCS_key_type[] =
{
	{CKK_DSA             ,_CK("CKK_DSA            ")},
	{CKK_DH              ,_CK("CKK_DH             ")},
	{CKK_GENERIC_SECRET  ,_CK("CKK_GENERIC_SECRET ")},
	{CKK_RC2             ,_CK("CKK_RC2            ")},
	{CKK_RC4             ,_CK("CKK_RC4            ")},
	{CKK_DES             ,_CK("CKK_DES            ")},
	{CKK_DES2            ,_CK("CKK_DES2           ")},
	{CKK_DES3            ,_CK("CKK_DES3           ")},
	{CKK_VENDOR_DEFINED  ,_CK("CKK_VENDOR_DEFINED ")},
    {CKK_CAST            ,_CK("CKK_CAST           ")},
    {CKK_CAST3           ,_CK("CKK_CAST3          ")},
    {CKK_CAST5           ,_CK("CKK_CAST5          ")},
    {CKK_RC5             ,_CK("CKK_RC5            ")},
    {CKK_IDEA            ,_CK("CKK_IDEA           ")},
    {CKK_SKIPJACK        ,_CK("CKK_SKIPJACK       ")},
    {CKK_BATON           ,_CK("CKK_BATON          ")},
    {CKK_JUNIPER         ,_CK("CKK_JUNIPER        ")},
    {CKK_CDMF            ,_CK("CKK_CDMF           ")},
    {CKK_ECDSA           ,_CK("CKK_ECDSA          ")},
    {CKK_KEA             ,_CK("CKK_KEA            ")},
	{CKK_RSA             ,_CK("CKK_RSA            ")}
};

/* PKCS objects */
PKCS_SPL_TS_TextCode PKCS_object_classes[] =
{
	{CKO_CERTIFICATE,   _CK("CKO_CERTIFICATE   ")},
	{CKO_PUBLIC_KEY,    _CK("CKO_PUBLIC_KEY    ")},
	{CKO_PRIVATE_KEY,   _CK("CKO_PRIVATE_KEY   ")},
	{CKO_SECRET_KEY,    _CK("CKO_SECRET_KEY    ")},
	{CKO_VENDOR_DEFINED,_CK("CKO_VENDOR_DEFINED")},
	{CKO_DATA,          _CK("CKO_DATA")}
};

/* List of text <=> code  */
static PKCS_SPL_TS_TextCodeList PKCS_TextCodeList[] =
{
	{ PKCS_SPL_RET_CODE,     &PKCS_return_code[0]},
	{ PKCS_SPL_SESSION_ST,   &PKCS_session_state[0]},
	{ PKCS_SPL_SESSION_FLG,  &PKCS_session_flag[0]},
	{ PKCS_SPL_KEY_ATTRB,    &PKCS_attribute[0]},
	{ PKCS_SPL_KEY_TYPE,     &PKCS_key_type[0]},
	{ PKCS_SPL_OBJ_TYPE,     &PKCS_object_classes[0]},
    { PKCS_SPL_MECHA_TYPE,   &PKCS_mechanism[0]},
    { PKCS_SPL_END_LIST,     NULL_PTR},
};

//----------------------------------------------------------------
//	 Function: ToUpper
//
//	Change string to uppercase
//		return	void
//		param	[IN/OU]	LPTSTR buffer : String to be transformed
//----------------------------------------------------------------
void ToUpper (LPTSTR buffer)
{
	/* Local variables */
	LPTSTR p = NULL;

	for (p = buffer; p != NULL && *p != '\0'; p = CharNext(p))
	{
		*p = (TCHAR)_totupper (*p);
	}
}

//----------------------------------------------------------------
//	 Function: GetString
//
//	Display a prompt to the user and get the response
//		return	void
//		param	[IN] LPCTSTR text		 : Prompt for the user
//		param	[OU] TCHAR	 buffer		 : String to be transformed 
//		param	[IN] int	 buffer_size : Maximum entry length
//-----------------------------------------------------------------
void GetString (LPCTSTR text, TCHAR *buffer, int buffer_size)
{
	/* Local variables */
	size_t	i;

	fwprintf (stdout, _T("\n%s : "), text);
	fflush(stdin);
	fgetws (buffer, buffer_size, stdin);
	for (i = _tcsnbcnt((const wchar_t *)buffer, _tcsclen((const wchar_t *)buffer)+1) - 1; i >= 0; i--)
	{
		if (buffer[i] == '\n')
		{
			buffer[i] = '\0';
			break;
		}
	}
}

//------------------------------------------------------------------------------------------
//	 Function: GetMenuChoice
//
//	Retrieves user entry in menu
//		return	void
//		param	[IN] int nMenuMin      : Min menu value
//		param	[IN] int nMenuMax	   : Max menu value 
//		param	[OU] int *pnMenuChoice : Selected menu value (-1 if not an available value ) 
//------------------------------------------------------------------------------------------
void GetMenuChoice (int nMenuMin, int nMenuMax, int *pnMenuChoice)
{
	/* Local variables */
	TCHAR szUserEntry[BUFSIZ];
	BOOL  bNum = TRUE;
	unsigned int i;

	GetString (_T("\nEnter your choice"), szUserEntry, (int)sizeof (szUserEntry));
	ToUpper(szUserEntry);
	
	/* Does user want to quit ? */
	if (_tcscmp (szUserEntry, PKCS_SPL_STRQUIT) == 0)
	{
		*pnMenuChoice = 0;
	}
	else
	{
		/* numeric entry ? */
		for (i=0; i < _tcsnbcnt((const wchar_t *)szUserEntry, _tcsclen((const wchar_t *)szUserEntry)+1) && bNum == TRUE; i++)
		{
			if (!isdigit (szUserEntry[i]))
				bNum = FALSE;
		}
		if (bNum == TRUE)
		{
			/* get menu choice */
			swscanf_s (szUserEntry, _T("%d"), pnMenuChoice);
		}
		
		/* is selected item available ? */
		if ( *pnMenuChoice < nMenuMin || *pnMenuChoice > nMenuMax)
		{
			fwprintf (stdout, _T("\nEnter available menu choice\n"));
			/* display again menu */
			*pnMenuChoice = -1;		
		}
	}
}

//---------------------------------------------------------------
//	 Function: GetPIN
//
//	Display a prompt for PIN to the user and get PIN
//		return	void
//		param	[IN] LPCTSTR message        : Prompt for the user
//		param	[OU] CK_UTF8CHAR_PTR *ppPIN	: PIN value 
//		param	[OU] CK_ULONG* pulPinLen	: PIN value length
//--------------------------------------------------------------
void GetPIN (LPCTSTR message, CK_UTF8CHAR_PTR *ppPIN, CK_ULONG* pulPinLen)
{
	/* Local variables */
	CK_UTF8CHAR_PTR pPIN = NULL;
	CK_ULONG ulPinLen = 0;
	TCHAR szUserEntry[BUFSIZ];
	BOOL bAlphaNum = FALSE;
	unsigned long i;

	while (bAlphaNum == FALSE)
	{
		GetString (message, szUserEntry, sizeof (szUserEntry));
	
		bAlphaNum = TRUE;
		/* alphanumeric entry? */
		for (i=0; i < _tcsnbcnt((const wchar_t *)szUserEntry, _tcsclen((const wchar_t *)szUserEntry)+1) && bAlphaNum == TRUE; i++)
		{
			if (!isalnum(szUserEntry[i]))
				bAlphaNum = FALSE;
		}
	}

	ulPinLen = WideCharToMultiByte(CP_ACP, 0, szUserEntry, (int)_tcslen(szUserEntry), 0, 0, 0, 0);
	pPIN = (CK_UTF8CHAR_PTR)GlobalAlloc(GMEM_FIXED, (ulPinLen+1)*sizeof(CK_UTF8CHAR));
	memset(pPIN,0,(ulPinLen+1)*sizeof(CK_UTF8CHAR));
	WideCharToMultiByte(CP_ACP, 0, szUserEntry, (int)_tcslen(szUserEntry), (LPSTR)pPIN, ulPinLen, 0, 0);

	if (ppPIN) *ppPIN = pPIN;
	if (pulPinLen) *pulPinLen = ulPinLen;
}

//-----------------------------------------------------------------------
//	 Function: Code2Text
//
//	Get text index into array corresponding to code value
//		return	CK_ULONG	: Index of text string in array
//		param	[IN] CK_ULONG  ulCode		: Code value needed to convert
//		param	[IN] CK_ULONG  ulTableIdent : Global array identifier
//		param	[OU] CK_BBOOL* pbRet		: Return Code TRUE or FALSE
//------------------------------------------------------------------------
CK_ULONG  Code2Text(CK_ULONG  ulCode, CK_ULONG  ulTableIdent, CK_BBOOL* pbRet)
{
	/* Local variables */
	CK_BBOOL               Found;
	CK_ULONG               Index;
	PKCS_SPL_TS_TextCode  *pTextCode; /* pointer to text/code array */
	
	Found = FALSE;
	Index = 0;

    /* Get array pointer */
	for (;;Index++) {
		if (ulTableIdent == PKCS_TextCodeList[Index].ulTbl_Ident) {
			*pbRet = TRUE;
			Found  = TRUE;
			break;
		} else {
			if (PKCS_TextCodeList[Index].ulTbl_Ident == PKCS_SPL_END_LIST) {
    			*pbRet = FALSE;
  				break;
			}
		}
	}

	if (Found) 
    {
		/* corresponding array exist => get it */
	    pTextCode = PKCS_TextCodeList[Index].pTbl_TextCode;
	    /* and search for code matching */
	    for (Index=0;;Index++) 
        {
    		if (ulCode == pTextCode->Code) 
            {
    			break; /* exit from search loop */
		    }
			else if (pTextCode->Code == (CK_ULONG)0) /* code not found */
			{
				*pbRet = FALSE;
    			break; /* exit from search loop */			
			}
		    pTextCode++;
	    }
    }

	return (Index);
}